/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ProfibusFspmm2_Functionlist.h $
   Last Modification:
    @version $Id: ProfibusFspmm2_Functionlist.h 18851 2011-08-23 12:57:05Z mark $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    Profibus Fspmm2
    Task function list for configuration file
       
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
        
**************************************************************************************/
/**
 * @file ProfibusFspmm2_Functionlist.h
 * @brief Profibus Fspmm2 - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_ProfibusFspmm2</code>
 * of task.
 */
#ifndef __PROFIBUS_FSPMM2_FUNCTIONLIST_H
#define __PROFIBUS_FSPMM2_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_ProfibusFspmm2
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT TaskLeave_ProfibusFspmm2
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);
                                             
TLR_VOID TaskEnter_ProfibusFspmm2
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PROFIBUS_FSPMM2_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PROFIBUS_FSPMM2_STARTUPPARAMETER_Ttag  PROFIBUS_FSPMM2_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PROFIBUS_FSPMM2_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32 ulTaskIdentifier; /* task identifier see TLR_TaskIdentifier.h */
  TLR_UINT32 ulParamVersion;   /* structure version */
  
  /** A dummy */
  TLR_UINT32  ulDummy;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PROFIBUS_FSPMM2_FUNCTIONLIST_H */
